;***********************************************************************

; Werkzeugliste fuer Drehen

;   DATUM        :   7.12.2003
;                    letzte Erweiterung:  2.5.2013

;   Copyright (C) 2003 - 2013 AdCAM Technologies GmbH

;***********************************************************************

; Leere Zeilen und Zeilen mit ';' sind nur Kommentare
; alle anderen Zeilen werden ausgegeben.
; Ausgabe einer leeren Zeile erfolgt durch Angabe von <empty>.
; keine Tabulatoren verwenden !!

; Parameter (Platzhalter) werden mit '$' angesprochen
; Die Parameter 0 bis 49 gelten jeweils fr ein Werkzeug,
; d.h. die Zeilen, die mindestens einen Parameter 0 bis 49
; enthalten werden pro Werkzeug 1x ausgegeben
; eine Zeile die '$$' enthlt wird jeweils zwischen den Werkzeugzeilen
; ausgegeben (dies darf keine Parameter 1 bis 49 enthalten)

; Zeilen die $<1> enthalten, werden bei Doppelschlittenmaschinen ausgegeben
; Zeilen die $<2> enthalten, werden bei Doppelschlittenmaschinen fr den
; 2. Revolver ausgegeben
; die Kennung $<1> und $<2> selbst wird nicht mit ausgegeben

; Wenn Zeilen bedingt ausgegeben werden sollen wird eine Bedingung innerhalb der Zeile eingefuegt
; oder am Ende angehaengt (diese selbst wird bei der Ausgabe nicht mit ausgegeben).
; Bedingungen koennen auch Parameter beinhalten und haben folgendes Format:
; $< bedingung >  bei bedingung = false  wird die Zeile nicht ausgegeben
; bedingung hat z.B. die Form  $1!=10  (alle Werkzeug bis auf Magazinplatz 10 werden ausgegeben)
; Vergleiche auf groesser oder kleiner werden zur Uebersicht so geschrieben:
; .GT. = >   (groesser)
; .GE. = >=  (groesser oder gleich)
; .LT. = <   (kleiner)
; .LE. = <=  (kleiner oder gleich)
; Beispiel:  $<$1.GT.12>  nur Werkzeuge ab Magazinplatz 13 werden ausgegeben


 *-----------------------------------------------------------------------------------------------------*
 |                                     W E R K Z E U G L I S T E                                       |
 |-----------------------------------------------------------------------------------------------------|
 |  Programm : $60                                                                 Datum: $53          |
 |  Maschine : $50                                                                                     |
 |-----------------------------------------------------------------------------------------------------|$<1>
 |                                        R E V O L V E R  1                             $<1>          |
 |-----------------------------------------------------------------------------------------------------|
 | Platz | Korr.  |   ID.NR.  |           Bezeichnung            |  S.Rad.  | X-Wert | Z-Wert | Breite |
 |       |Schalter|           |                                  |  Durchm. |        |        |        |
 |-----------------------------------------------------------------------------------------------------|
 | $1    | $2$12  | $3        | $4                               |  $5      | $6     | $7     | $8     |
 |-------|--------|-----------|----------------------------------|----------|--------|--------|--------|$$
 |-----------------------------------------------------------------------------------------------------|$<2>
 |                                        R E V O L V E R  2                             $<2>          |
 |-----------------------------------------------------------------------------------------------------|$<2>
 |-----------------------------------------------------------------------------------------------------|
 |  Gesamtzeit:   $55                                                                                  |
 *-----------------------------------------------------------------------------------------------------*
<empty>
$99

; normal werden nur benutzte Werkzeuge aufgelistet,
; sonst folgenden Befehl aktivieren
; all_tools = true

; Parameterdefinition beginnt mit $, Nummer und '='
; Werkzeugparameter entalten jeweils den Member der Werkzeugvariablen
; alle anderen Zuweisungen mssen direkt die (globale) Variable oder den Funktionaufruf enthalten
; mit | werden folgende Optionen unterschieden:
; 1. Wert = Parameter
; 2. Wert = Alternativparameter, Sonderfunktion (mit $<...>) oder Prfung mit Bedingung
;           Beispiel: ?($<0):0 -> heisst: wenn Wert kleiner 0 setze den Wert auf 0
; 3. Wert = Formatangabe (siehe NcS Dokumentation 'FormatString')
;           Typbezeichner: i fr int, f fr real(floating) und s fr string

$1=.magPos||%3i                                         ; Magazinplatz
$2=.corrNr1||%2i                                        ; Korrekturschalter
$12=.corrNr2|?($<=0):" "|/%i                            ; 2. Korrekturschalter (nur wenn > 0)
$3=.toolID||%9s                                         ; Identnummer (9 Stellen rechtsbndig)
;$4=.name                                                ; Bezeichnung
$4=.name||%32s                                          ; Bezeichnung (32 Stellen rechtsbndig)
$5=.tipRadius|.d1|%5.2f                                 ; Schneidenradius (alternativ Durchmesser)
$6=.ys||%6.1f                                           ; Einstellmass in X
$7=.xs||%6.1f                                           ; Einstellmass in Y
$8=.grooveWidth|?($<=0.):"  -"|%5.1f                    ; Einstechbreite (wenn <= 0 dann wird '-' eingetragen)
$49=.time|?($<=0.):0|%5.1f                              ; Einsatzzeit des Werkzeuges

$50=glob_machine.name                                   ; Name der Maschine
$51=glob_machine.ppName                                 ; Name der Steuerungskonfiguration
$52=glob_machine.configName                             ; Name der Konfiguration
$53=Date()                                              ; aktuelles Datum
;$55=round(2,akt_zeit)+" min"                            ; Bearbeitungszeit in Minuten (auf 2 Stellen gerundet)
;$55=GetTime_hms(akt_zeit)                               ; Bearbeitungszeit (in min und s)
$55=GetTimeString(round(akt_zeit*60.))                  ; Bearbeitungszeit (xx:xx:xx)
$60=GetBaseName(ncsWorkspaceFile)                       ; aktueller Projektname (ohne Pfadangabe)
$99=replaceExpression(jobSheet_string)                  ; Kommentar fr Einrichtebaltt

