;***********************************************************************

; Werkzeugliste fuer Bohren/Fraesen

;   DATUM        :   7.12.2003
;                    letzte Erweiterung:  2.5.2013

;   Copyright (C) 2003 - 2013 AdCAM Technologies GmbH

;***********************************************************************

; Leere Zeilen und Zeilen mit ';' sind nur Kommentare
; alle anderen Zeilen werden ausgegeben
; keine Tabulatoren verwenden !!

; Parameter (Platzhalter) werden mit '$' angesprochen
; Die Parameter 0 bis 49 gelten jeweils fr ein Werkzeug,
; d.h. die Zeilen, die mindestens einen Parameter 0 bis 49
; enthalten werden pro Werkzeug 1x ausgegeben
; Zeilen die 1x '$$' enthalten sind jeweils Zeilen zwischen
; den Werkzeugzeilen (diese drfen keine Parameter 1 bis 49 enthalten)

; Wenn Zeilen bedingt ausgegeben werden sollen wird eine Bedingung innerhalb der Zeile eingefuegt
; oder am Ende angehaengt (diese selbst wird bei der Ausgabe nicht mit ausgegeben).
; Bedingungen koennen auch Parameter beinhalten und haben folgendes Format:
; $< bedingung >  bei bedingung = false  wird die Zeile nicht ausgegeben
; bedingung hat z.B. die Form  $1!=10  (alle Werkzeug bis auf Magazinplatz 10 werden ausgegeben)
; Vergleiche auf groesser oder kleiner werden zur Uebersicht so geschrieben:
; .GT. = >   (groesser)
; .GE. = >=  (groesser oder gleich)
; .LT. = <   (kleiner)
; .LE. = <=  (kleiner oder gleich)
; Beispiel:  $<$1.GT.12>  nur Werkzeuge ab Magazinplatz 13 werden ausgegeben


 *------------------------------------------------------------------------------------------------*
 |                                  W E R K Z E U G L I S T E                                     |
 |  Programm : $60                                                            Datum: $53          |
 |  Maschine : $50                                                                                |
 |------------------------------------------------------------------------------------------------|
 |  ID.NR.  |        Bezeichnung       | Platz |   D1   |  Lnge   | Sp.-Winkel | Steigung | Tol. |
 |------------------------------------------------------------------------------------------------|
 | $1       | $2                       | $3    | $4     | $5       | $6         | $7       | $8   |
 |          | $$                       |       |        |          |            |          |      |
 |------------------------------------------------------------------------------------------------|
 |  Gesamtzeit:   $55                                                                             |
 *------------------------------------------------------------------------------------------------*
<empty>
$99

; normal werden nur benutzte Werkzeuge aufgelistet,
; sonst folgenden Befehl aktivieren
; all_tools = true

; Parameterdefinition beginnt mit $, Nummer und '='
; Werkzeugparameter entalten jeweils den Member der Werkzeugvariablen
; alle anderen Zuweisungen mssen direkt die (globale) Variable oder den Funktionaufruf enthalten
; mit | werden folgende Optionen unterschieden:
; 1. Wert = Parameter
; 2. Wert = Alternativparameter, Sonderfunktion (mit $<...>) oder Prfung mit Bedingung
;           Beispiel: ?($<0):0 -> heisst: wenn Wert kleiner 0 setze den Wert auf 0
; 3. Wert = Formatangabe (siehe NcS Dokumentation 'FormatString')
;           Typbezeichner: i fr int, f fr real(floating) und s fr string

$1=.toolID||%8s                                         ; Identnummer (8 Stellen rechtsbndig)
$2=.name||%24s                                          ; Bezeichnung (24 Stellen rechtsbndig)
;$2=.name                                                ; Bezeichnung (linksbndig)
$3=.magPos||%3i                                         ; Magazinplatz
$4=.minD||%6.2f                                         ; (kleinster) Durchmesser (auf 2 Nachkommastellen gerundet)
$5=.xs||%7.2f                                           ; Werkzeuglnge (auf 2 Nachkommastellen gerundet)
$6=.topAngle|?($<=0.):180|%7.1f                         ; Spitzenwinkel (wenn <= 0 dann wird 180 eingetragen)
$7=.threadGradient|?($<=0.):"   -"|%6.2f                ; Gewindesteigung (wenn <= 0 dann wird '-' eingetragen)
$8=.tolerance|" -"                                      ; Toleranz (wenn nicht gesetzt dann wird '-' eingetragen)
$12=.corrNr1||%2i                                       ; Korrekturschalter
$13=.toolCall||%4s                                      ; Werkzeugaufruf (4 stellig, rechtsbndig)
$14=.sequ||%2s                                          ; Reihenfolge bei Abarbeitung
$44=.remark|-|                                          ; Kommentar des Werkzeugs
$49=.time|?($<=0.):0|%6.1f                              ; Einsatzzeit des Werkzeuges

$50=glob_machine.name                                   ; Name der Maschine
$51=glob_machine.ppName                                 ; Name der Steuerungskonfiguration
$52=glob_machine.configName                             ; Name der Konfiguration
$53=Date()                                              ; aktuelles Datum
;$55=round(2,akt_zeit)+" min"                            ; Bearbeitungszeit in Minuten (auf 2 Stellen gerundet)
;$55=GetTime_hms(akt_zeit)                               ; Bearbeitungszeit (in min und s)
$55=GetTimeString(round(akt_zeit*60.))                  ; Bearbeitungszeit (xx:xx:xx)
$60=GetBaseName(ncsWorkspaceFile)                       ; aktueller Projektname (ohne Pfadangabe)
$99=replaceExpression(jobSheet_string)                  ; Kommentar fr Einrichtebaltt

